definition module EdDrawWindow;

import EdTypes, EdProgramState;

/* Draws line insertion/removal in the front window												*/
DrawCurLine :: !EditWindow !LineUpdate !ProgState !IO -> ProgIO;

/* Draw character(s) insertion/removal in/from the current line of the front window				*/
DrawCurChars :: !Char !EditWindow !LineUpdate !ProgState !IO -> ProgIO;

/* Freezes the cursor at the current position, when 1st arg is True, otherwise cursor is		*/
/* changed into a blinking one.																			*/
DrawFreezeCursor :: !Bool !ProgState !IO -> ProgIO;

/* Makes the changes made to the text in the window indicated by the 1st arg. visable on the	*/
/* screen.																						*/
DrawTextUpdate :: !EditWdId !ScrollMode !WindowUpdate !ProgState !IO -> ProgIO;

/* Makes the changes made by the 2nd arg. visable in the window indicated by the first arg.		*/
DrawUpdateWindow :: !EditWdId !(EditWindow -> EditWindow) !ProgState !IO -> ProgIO;

/* Scrolls the window indicated by the 1st arg. up or down, or to begin or end, as indicated	*/
/* by the 2nd arg.																				*/
DrawScrollWindow :: !EditWdId !Char !ProgState !IO -> ProgIO;

/* Draws selection/unselection (indicated by 3rd arg) in the window indicated by 2nd arg. If	*/
/* 1st arg is True the is scrolled to make the cursor position visable.							*/
DrawSelect :: !Bool !EditWdId !WindowUpdate !ProgState !IO -> ProgIO;

/* The update function for the windows															*/
UpdateWindow :: !EditWdId !UpdateArea !ProgState -> (!ProgState, ![DrawFunction]);

/* Determines mouse position when the mouse button is still down and the mouse is dragged		*/
/* outside the front window frame																*/
DragOutsideFrame :: !MouseState !ProgState !IO -> (!ProgState,!IO,!Int,!Int);
